
--# Main
--created by niorg2606
--made 3D by UberGoober

function setup()
    -- makeOrbInCorner()
    scene = craft:scene()
    craft.scene.main = scene
    craft.scene.main.sky.active = false
    scene:update(DeltaTime)
    scene:draw()
    displayMode(FULLSCREEN_NO_BUTTONS)
    supportedOrientations(LANDSCAPE_RIGHT)
    state = "menu"
    theme = "dark"
    playing = false
    score = 0
    music("Game Music One:Zero", true)
    menuButtons = {
        Button("Play", WIDTH/2, HEIGHT/2, color(0, 255, 0, 255), function() 
            print("Delay")
            state="game" 
        end), 
        Button("Exit", WIDTH/2, HEIGHT/2-200, color(255, 0, 0, 255), function() close() end),
        Button(" ? ", WIDTH/2+200, HEIGHT/2, color(255, 120, 0, 255), function() state = "manuel"
        music.volume = 0.2 end),
        Button("⚙", WIDTH-100, HEIGHT-100, color(100, 255), function() state = "settings"
        music.volume = 0.2 end)
    }
    manuelButtons = {
        Button("Back", WIDTH/2, 100, color(255, 255, 0, 255), function()
            state = "menu"
            music.volume = 1.0
        end)
    }
    settingsButtons = {
        Button("Back", WIDTH/2, 100, color(255, 255, 0, 255), function() state = "menu"
        music.volume = 1.0 end),
        Button("Default", 150, HEIGHT-50, color(255, 255, 255, 255), function() music("Game Music One:Zero", true) 
            theme = "dark"
        enemy.maxSpeed = 10 end),
        Button("On", 550, HEIGHT-100, color(255, 255, 255, 255), function() music("Game Music One:Zero", true) end),
        Button("Off", 650, HEIGHT-100, color(255, 255, 255, 255), function() music.stop() end),
        Button("Dark", 580, HEIGHT-200, color(100, 100, 100, 255), function() theme = "dark" end),
        Button("Light", 740, HEIGHT-200, color(200, 200, 200, 255), function() theme = "light" end),
        Button("Weird", 915, HEIGHT-200, color(0, 200, 0, 255), function() theme = "weird" end),
        Button("Normal", 610, HEIGHT-300, color(0, 255, 0, 255), function() displayMode(FULLSCREEN_NO_BUTTONS) end),
        Button("Debug", 800, HEIGHT-300, color(255, 255, 0, 255), function() displayMode(STANDARD) end),
        Button(" <", 610, HEIGHT-400, color(255, 0, 0, 255), function() enemy.maxSpeed = enemy.maxSpeed - 1 end),
        Button("> ", 800, HEIGHT-400, color(0, 255, 0, 255), function() enemy.maxSpeed = enemy.maxSpeed + 1 end)
    }
    stationaryObs = {
        Obstical(math.random(WIDTH), math.random(HEIGHT), "stationary", 50),
        Obstical(math.random(WIDTH), math.random(HEIGHT), "stationary", 50),
        Obstical(math.random(WIDTH), math.random(HEIGHT), "stationary", 50)
    }
    enemy = Obstical(math.random(WIDTH), math.random(HEIGHT), "chase", 50)
    coin = Collectable(math.random(WIDTH), math.random(HEIGHT))
    player = makeOrb(100, vec2(0,0), color(244, 243, 242))
    hideAllOrbsButEnemy()
end

function draw()
    if (theme == "dark") then 
        themeColor = color(0, 0, 0, 255)
        craft.scene.main.camera:get(craft.camera).clearColor = themeColor
    elseif (theme == "light") then 
        themeColor = color(182, 182, 182, 255)
        craft.scene.main.camera:get(craft.camera).clearColor = themeColor
    elseif (theme == "weird") then 
        themeColor = color(25, 159, 25, 255)
        craft.scene.main.camera:get(craft.camera).clearColor = themeColor
    end
    if (state == "menu") then
        fontSize(96)
        font("Baskerville-Bold")
        fill(255, 0, 20, 255)
        text("Finger Chase", WIDTH/2, HEIGHT-200)
        for i,v in ipairs(menuButtons) do
            fontSize(48)
            v:draw()
        end
    elseif (state == "game") then
        if (playing == false) then
            background(0)
            fontSize(60)
            fill(64, 64, 64, 255)
            text("Put your finger on screen to start.", WIDTH/2, HEIGHT/2)
        else
            fill(255, 255, 255, 255)
            --pointer = ellipse(CurrentTouch.x, CurrentTouch.y, 100)
            player.position = craftPositionFrom(vec2(CurrentTouch.x, CurrentTouch.y))
            enemy:draw()
            coin:draw()
            for i,v in ipairs(stationaryObs) do
                v:draw()
            end
        end
    elseif (state == "manuel") then
        fill(255, 255, 255, 255)
        fontSize(30)
        text("You play as a circle that is trying to collect the yellow coins.", WIDTH/2, HEIGHT-100)
        text("The circle cannot touch any red obsticles, one of which is chasing you.", WIDTH/2, HEIGHT-125)
        text("Collect as many coins as possible without touching the red", WIDTH/2, HEIGHT-150)
        text("and do NOT let go.", WIDTH/2, HEIGHT-175)
        text("V1.1", WIDTH-75, 25)
        for i,v in ipairs(manuelButtons) do
            v:draw()
        end
    elseif (state == "settings") then
        fontSize(30)
        fill(255, 255, 255, 255)
        text("Music", 400, HEIGHT-100)
        text("Theme", 400, HEIGHT-200)
        text("Mode", 400, HEIGHT-300)
        text("Max Enemy Speed", 310, HEIGHT-400)
        text(enemy.maxSpeed, 700, HEIGHT-400)
        for i,v in ipairs(settingsButtons) do
            v:draw()
        end
    elseif (state == "gameover") then
        setOrbsVisible(false)
        enemy.entity.active = true
        fontSize(60)
        fill(255, 0, 0, 255)
        text("Game Over!", WIDTH/2, HEIGHT/2)
        text("You got " .. score .. " points", WIDTH/2, 200)
    end
end

function touched(touch) 
    if (state == "menu") then
        for i,v in ipairs(menuButtons) do
            v:touched(touch)
        end
    elseif (state == "game") then
        if (not playing and touch.state == BEGAN) then
            setOrbsVisible(true)
            playing = true
        end
        if (playing) then
            if (touch.state == ENDED) then
                state = "gameover"
                setOrbsVisible(false)
                enemy.entity.active = true
            end
        end
    elseif (state == "manuel") then
        for i,v in ipairs(manuelButtons) do
            v:touched(touch)
        end
    elseif (state == "settings") then
        for i,v in ipairs(settingsButtons) do
            v:touched(touch)
        end
    elseif (state == "gameover") then
        if (touch.state == BEGAN) then
            playing = false
            score = 0
            for i,v in ipairs(stationaryObs) do
                placeAtRandomPosition(v)
            end
            placeAtRandomPosition(enemy)
            sound("Game Sounds One:Menu Select")
            state = "menu"
        end
    end
end
